var UR = UR || {};

UR.render = {
	widgets : { // TODO: Auto gen from enums
		3  : "Button",
		4  : "Label",
		5  : "List",
		6  : "Item",
		7  : "Slider",
		8  : "Action",
		9  : "Message",
		10 : "Dialog",
		11 : "Input",
		12 : "Orb",
		13 : "Image",
		14 : "Text",
		15 : "Toggle",
		16 : "TOrb",
		17 : "Touch",
		20 : "Tab",
		21 : "Row",
		22 : "Tabs",
		23 : "Space",
		24 : "Area"
	},

	classname: function(type) {
		return "remote-" + (type || "").toLowerCase();
	},

	toAction: function(elm, tabCounter) {
		var t = UR.render.widgets[elm.Type];
		var action = _.cloneDeep(elm);
		action['Type'] = t;
		action['Debug'] = elm.Type + " -> " + t;
		action['Class'] = UR.render.classname(t);
		action['TabId'] = tabCounter;
		if (elm.Icon !== undefined) {
			action['Icon'] = UR.icons.resolveFa(elm.Icon);
		}

		if (elm.Text !== undefined) {
			action['Text'] = elm.Text;
		}

		return action;
	},

	flattenLayout: function(layout) {
		var actionsrows = [[]];

		// Containers
		var Ttab  = "Tab";
		var Trow  = "Row";
		var Ttabs = "Tabs";
		var Tspace = "Space";

		// Supported
		var supported = ["Button", "Label", "Slider", "Image", "Toggle"]

		var recurs;
		var tabCounter = 0;
		recurs = function(layout, isInTabs) {
			_.forEach(layout.Children, function(child) {
				var t = UR.render.widgets[child.Type];

				if (t === Ttabs) { //Tabs
					recurs(child, true);
					return;
				}

				if (t === Ttab && isInTabs) {
					tabCounter++;
				}

				if (t === Trow || t === Ttab) { //Row
					actionsrows.push([]);
					recurs(child, false);
					return;
				}

				if (t !== Tspace) {
					actionsrows[actionsrows.length-1].push(
						UR.render.toAction(child, tabCounter)
					);
				}
			});
		};

		if (layout.Default !== undefined) {
			recurs(layout.Default, false);
		} else {
			tip("No layout for this remote");
		}

		var unsupported = {};
		_.forEach(actionsrows, function(group) {
			_.forEach(group, function(child) {
				var old = unsupported[child.TabId];
				var new_uniq = _.union(old, [child.Type]);
				unsupported[child.TabId] = $(new_uniq).not(supported).get();
			});
		});

		var i = 0;
		var groups = actionsrows;
		groups = _.chain(groups)
			.filter(function(arr) {
				return _.any(arr, function(action) {
					var unsp = unsupported[action.TabId];
					return (
						_.isEmpty(arr) ||
						_.isEmpty(unsp)
					)
				});
			})
			.map(function(arr) {
				i++;
				return {
					Actions: arr,
					Name: "Group::" + i,
					GroupId: i
				};
			}).value(); // Get back to js after lodash chaining

		return {
			Groups: groups
		};
	},
	getWidgetElement: function (obj) {
		return $('#' + obj.ID);
	},
	getIconElement: function (elm) {
		return elm.children(".remote-icon");
	},
	getImageElement: function (elm) {
		return elm.children(".remote-image");
	},
	getTextElement: function (elm) {
		return elm.children(".remote-text");
	},
	getSliderElement: function (elm) {
		return elm.children("input[type=range]");
	},
	getSliderTextElement: function (elm) {
		return elm.children("center").children(".remote-slider-text");
	},
	getSliderValueTextElement: function (elm) {
		return elm.children("center").children(".remote-slider-value-text");
	},

	bindHold: function(obj, onHoldCallback) {
		if (!(obj || {}).OnHold) return;
		var h = UR.render.getWidgetElement(obj);

		h.bind("taphold", onHoldCallback);
	},

	setSliderMaxProgress: function (obj) {
		var h = UR.render.getWidgetElement(obj);
		var s = UR.render.getSliderElement(h);
		s.attr("max", obj.ProgressMax);
	},

	setSliderProgress: function (obj) {
		var h = UR.render.getWidgetElement(obj);
		var s = UR.render.getSliderElement(h);
		s.val(obj.Progress);

		try {
			var max = parseFloat(s.attr("max"));
			var proc = (100 * obj.Progress) / max;
			var rounded_proc = Math.round(proc);
			var t = UR.render.getSliderValueTextElement(h);
			t.text(" - " + rounded_proc + "%");
		} catch (err) {

		}
	},

	setSliderText: function (obj) {
		var h = UR.render.getWidgetElement(obj);
		UR.render.getSliderTextElement(h).text(obj.Text);
	},

	setText: function(obj) {
		var h = UR.render.getWidgetElement(obj);
		UR.render.getTextElement(h).text(obj.Text);
	},

	setIcon: function(obj) {
		var h = UR.render.getWidgetElement(obj);
		var i = UR.render.getIconElement(h);
		var faIcon = UR.icons.resolveFa(obj.Icon);

		i.attr("class", "");
		i.addClass("remote-icon");
		i.addClass(faIcon);
	},

	setChecked: function (obj, checked) {
		var h = UR.render.getWidgetElement(obj);
		if (checked) {
			h.removeClass("raised");
			h.attr("data-down", "yes");
		} else {
			h.addClass("raised");
			h.attr("data-down", "no");
		}
	},

	isChecked: function(obj) {
		var h = UR.render.getWidgetElement(obj);
		return h.attr("data-down") === "yes";
	},

	setImage: function(obj) {
		var h = UR.render.getWidgetElement(obj);
		var img = UR.render.getImageElement(h);
		img.attr("src", "data:image/jpg;base64," + obj.Image );
	},

	nl2br: function (obj) {
		return obj.replace(/(\r\n|\n\r|\r|\n)/g, "<br>");
	},

	br2nl: function(obj) {
    return obj.replace(/<br>/g, "\n");
	},

	prettyRows: function (groups) {
		var fg = _.first(groups.Groups); // First group
		var tab = (_.first((fg || {}).Actions) || {}).TabId;

		_.forEach(groups.Groups, function(group) {

			if ((group.Actions || []).length <= 1)  return;

			var easy = ["Button", "Label", "Toggle"];

			var any_hard = _.any(group.Actions, function(obj) {
				return _.indexOf(easy, obj.Type) === -1;
			});

			if (any_hard) return;

			var largest = _.max(group.Actions, function(obj) {
				return $("#" + obj.ID).height();
			});

			var height = $("#" + largest.ID).height();

			_.forEach(group.Actions, function (obj) {
				if (obj.TabId !== tab) {
					group['StartOfTab'] = true;
					tab = obj.TabId;
				}

				$("#" + obj.ID).height(height);
			});

		});
	}
};
