var UR = UR || {};

UR.events = {

	publish: function(evt, remote) {
		if (evt.KeepAlive) {
			console.debug("Received KeepAlive from server");
		} else {
			var layout = evt.Layout;
			var controls = layout.Controls;
			_.forEach(controls, function(value) {

				if (evt.ID !== remote.ID) {
					console.debug("Event from unloaded remote " + evt.ID + ", unloading remote...");
					UR.client.instance.stopRemote(remote);
					return;
				}

				if (value.Text) {
					UR.render.setText(value);
					UR.render.setSliderText(value);
				}

				if (value.ProgressMax) {
					UR.render.setSliderMaxProgress(value);
				}

				if (value.Progress) {
					var awaitValue = model.current_sync_queue[value.ID];

					if (awaitValue !== undefined && awaitValue !== value.Progress)
						return;

					if (awaitValue !== undefined && awaitValue === value.Progress)
						model.current_sync_queue[value.ID] = undefined;

					UR.render.setSliderProgress(value);
				}

				if (value.Icon) {
					UR.render.setIcon(value);
				}

				if (value.Image) {
					UR.render.setImage(value);
				}

				if (value.Checked) {
					UR.render.setChecked(value);
				}

			});
		}
	}

};
